	// Funzione pulsante "dati del tempo" 
	
	 function mercury_tab(obj)
	{  
		// Firma digitale 
		if (obj.FIRMA.value == "     Agostino Frosini  -  Javascript Software 2020  -") 
			{
				// Dichiarazioni delle variabili 	
				giorno = myParseFloat(obj.giorno.value);
				if (giorno >31 | giorno <= 0)
					{
						alert("\n GIORNO ERRATO: \n\n DATI VALIDI DA 1 A 31 \n\n CLICCA SU RESET E RIPROVA"); 
					}
				mese = myParseFloat(obj.mese.value);
				if (mese >12 | mese <= 0)
					{
						alert("\n MESE ERRATO: \n\n DATI VALIDI DA 1 A 12 \n\n CLICCA SU RESET E RIPROVA");  
					}
				anno = myParseFloat(obj.anno.value);

				ore = myParseFloat(obj.ore.value); 
				if (ore >=24 | ore < 0)
					{
						alert("\n ORE ERRATE: \n\n DATI VALIDI DA 0 A 23 \n\n CLICCA SU RESET E RIPROVA"); 
					}
				minuti = myParseFloat(obj.minuti.value); 
				if (minuti >=60 | minuti < 0)
					{
						alert("\n MINUTI ERRATI: \n\n DATI VALIDI DA 0 A 59 \n\n CLICCA SU RESET E RIPROVA"); 
					}
				secondi = myParseFloat(obj.secondi.value); 
				if (secondi >=60 | secondi < 0)
					{
						alert("\n SECONDI ERRATI: \n\n DATI VALIDI DA 0 A 59 \n\n CLICCA SU RESET E RIPROVA"); 
					}		
				lat_G = myParseFloat(obj.lat_G.value); 
				if (lat_G >= 90 | lat_G <= -90)
					{
						alert("\n GRADI LATITUDINE ERRATI: \n\n DATI VALIDI DA -89 A +89 \n\n CLICCA SU RESET E RIPROVA"); 
					}
				lat_M = myParseFloat(obj.lat_M.value); 
				if (lat_M >= 60 | lat_M <= -60)
					{
						alert("\n PRIMI LATITUDINE ERRATI: \n\n DATI VALIDI DA -59 A +59 \n\n CLICCA SU RESET E RIPROVA"); 
					}
				lat_S = myParseFloat(obj.lat_S.value);
				if (lat_S >= 60 | lat_S <= -60)
					{
						alert("\n SECONDI LATITUDINE ERRATI: \n\n DATI VALIDI DA -59 A +59 \n\n CLICCA SU RESET E RIPROVA"); 
					}
				long_G = myParseFloat(obj.long_G.value); 
				if (long_G >= 180 | long_G <= -180)
					{
						alert("\n GRADI LONGITUDINE ERRATI: \n\n DATI VALIDI DA -179 A +179 \n\n CLICCA SU RESET E RIPROVA"); 
					}
				long_M = myParseFloat(obj.long_M.value); 
				if (long_M >= 60 | long_M <= -60)
					{
						alert("\n PRIMI LONGITUDINE ERRATI: \n\n DATI VALIDI DA -59 A +59 \n\n CLICCA SU RESET E RIPROVA"); 
					}
				long_S = myParseFloat(obj.long_S.value); 
				if (long_S >= 60 | long_S <= -60)
					{
						alert("\n SECONDI LONGITUDINE ERRATI: \n\n DATI VALIDI DA -59 A +59 \n\n CLICCA SU RESET E RIPROVA"); 
					}
	
				// Prepara l'oggetto giorno e mese inferiori a 10 con lo zero davanti al numero per il confronto con il 15821015
				if (obj.giorno.value < 10) obj.giorno.value = "0"+obj.giorno.value;
				if (obj.mese.value < 10) obj.mese.value = "0"+obj.mese.value;
		
				// Unisce anno mese giorno in una stringa 
				s = (obj.anno.value+obj.mese.value+obj.giorno.value);
		
				// La stringa data unita ritorna numero 
				s = parseInt(s);  	
			    
				
				// Calcolo dei giorni e ore decimali
				giorno_dec = (secondi / 3600 + minuti / 60 + ore)/24 + giorno;
				giorno_dec_et = ((secondi + et()[4])/ 3600 + minuti / 60 + ore)/24 + giorno;
				
				ore_dec = secondi / 3600 + minuti /60 + ore;
	
	
				// Conversione latitudine in gradi decimali 	
				lat_dec = lat_S / 3600 + lat_M / 60 + lat_G;
					
				// Conversione longitudine in gradi decimali
				long_dec = long_S / 3600 + long_M /60 + long_G;
		
				// Return da funzione jd_ore_0 contenuta in jd_ore_0.js  
				// Creazione variabile JD_0  
				JD_0 = jd_ore_0();
				
				// Return da funzione jd_ore_ut contenuta in jd_ore_ut.js
				// Creazione variabile JD_UT   
				JD_UT = jd_ore_ut(); 
				
				JD_ET = jd_ore_et(); 
	
			// Inizio del calcolo ----------------------------------------------------------------
				
			// variabili per la trasformazione di gradi e radianti 
			var r = Math.PI / 180; 
			var r1 = 180 / Math.PI;
			
			// secoli 
			var T = (JD_UT - 2451545.0)/36525;
			
			// millenni 
			var ro = (JD_UT - 2451545.0)/365250;	
			
			var L = mercury_vsop87(ro)[0];
			var B = mercury_vsop87(ro)[1];
			var R = mercury_vsop87(ro)[2];
			var L_E = mercury_vsop87(ro)[3];
			var B_E = mercury_vsop87(ro)[4];
			var R_E = mercury_vsop87(ro)[5];
			
			
			var long_ecl_real_0 = L ;
			var lat_ecl_real_0 = B ; 


			

			var x0 = R * Math.cos(B*r) * Math.cos(L*r) - R_E * Math.cos(B_E*r) * Math.cos(L_E*r); 
			var y0 = R * Math.cos(B*r) * Math.sin(L*r) - R_E * Math.cos(B_E*r) * Math.sin(L_E*r); 
			var z0 = R * Math.sin(B*r) - R_E * Math.sin(B_E*r); 

			var delta0 = Math.sqrt(Math.pow(x0,2) + Math.pow(y0,2) + Math.pow(z0,2)); 
			
			var delta0_GM = delta0 * 149597870.691 / 1000000;

			var t0 = 0.0057755183 * delta0;
			
			
			var ro1 = ((JD_UT - t0) - 2451545.0)/365250;


// ----------------------------Cambio ro per effetto del tempo luce --------------------------------


			var L_TL = mercury_TL_vsop87(ro1)[0];
			var B_TL = mercury_TL_vsop87(ro1)[1];
			var R_TL = mercury_TL_vsop87(ro1)[2];
			var L_E_TL = mercury_TL_vsop87(ro1)[3];
			var B_E_TL = mercury_TL_vsop87(ro1)[4];
			var R_E_TL = mercury_TL_vsop87(ro1)[5];
			
		
			var R_TL_GM = R_TL * 149597870.691 / 1000000;


			var x1 = R_TL * Math.cos(B_TL*r) * Math.cos(L_TL*r) - R_E_TL * Math.cos(B_E_TL*r) * Math.cos(L_E_TL*r); 
			var y1 = R_TL * Math.cos(B_TL*r) * Math.sin(L_TL*r) - R_E_TL * Math.cos(B_E_TL*r) * Math.sin(L_E_TL*r); 
			var z1 = R_TL * Math.sin(B_TL*r) - R_E_TL * Math.sin(B_E_TL*r); 
						

			var delta1 = Math.sqrt(Math.pow(x1,2) + Math.pow(y1,2) + Math.pow(z1,2)); 
			
			var delta1_GM = delta1 * 149597870.691 / 1000000;

			var t1 = 0.0057755183 * delta1;

			var long_ecl_0 = Math.atan2(y1,x1)*r1;
			if(long_ecl_0<0){long_ecl_0=long_ecl_0+360}

			var lat_ecl_0 = Math.atan2(z1,Math.sqrt(Math.pow(x1,2) + Math.pow(y1,2)))*r1;

			var fk5_L1 = long_ecl_0 - 1.397 * T - 0.00031 * Math.pow(T,2); 
			
			var fk5_DL = -0.09033 + 0.03916 * (Math.cos(fk5_L1*r) + Math.sin(fk5_L1*r)) * Math.tan(lat_ecl_0*r); 
			var fk5_DB = 0.03916 * (Math.cos(fk5_L1*r) - Math.sin(fk5_L1*r)); 
	
	
			var long_ecl_1 = long_ecl_0 + fk5_DL / 3600 ; 
			var lat_ecl_1 = lat_ecl_0 + fk5_DB  / 3600 ;
	
			var nut_DL = nut_ut()[6]/3600; 
	
			var long_ecl_2 = long_ecl_1 + nut_DL ; 
			var lat_ecl_2 = lat_ecl_1  ;
			
			var E1 = nut_ut()[8]; 
	
			var ar = Math.atan2(Math.sin(long_ecl_2*r)*Math.cos(E1*r)-Math.tan(lat_ecl_2*r)*Math.sin(E1*r),Math.cos(long_ecl_2*r))*r1;
			if(ar<0){ar=ar+360}
			var ar_h = ar / 15;
			
			var dec = Math.asin(Math.sin(lat_ecl_2*r)*Math.cos(E1*r)+Math.cos(lat_ecl_2*r)*Math.sin(E1*r)*Math.sin(long_ecl_2*r))*r1;
	
				
				//  -------------------- calcolo altezza e azimut -----------------------------------
			// return da funzione ts_ut_c contenuta in ts_ut_corretto.js 
			var ts_dec = ts_ut_c()[6];
		
			// Conversione latitudine in gradi decimali 	
			var lat_dec = lat_S / 3600 + lat_M / 60 + lat_G;
				
			// Conversione longitudine in gradi decimali
			var long_dec = long_S / 3600 + long_M /60 + long_G;
				
			// Tempo dell'astro locale
			var Tx = ts_dec - ar - long_dec * - 1;
		
			if (Tx < 0) {Tx = Tx + 360}

			if (Tx > 360) 
				{
					Tx = Tx - 360;
				}
		 
			// Angolo al Polo  
			var p = Tx;
		
			if (p > 360) 
				{
					p = p - 360;
				}
			
			if (p < 180) 
				{
					p = p * -1;
				}
			
			if (p > 180)
				{
					p = 360 - p; 
				}
	
			// Formula altezza 
			var h = Math.asin(Math.sin(lat_dec*Math.PI/180)*Math.sin(dec*Math.PI/180)+Math.cos(lat_dec*Math.PI/180)*Math.cos(dec*Math.PI/180)*Math.cos(p*Math.PI/180))*180/Math.PI;	
		
			// Formula azimut numeratore 
			var n = Math.sin(p*Math.PI/180);
		
			// Formula azimut denominatore 
			var d = Math.tan(dec*Math.PI/180)*Math.cos(lat_dec*Math.PI/180)-Math.sin(lat_dec*Math.PI/180)*Math.cos(p*Math.PI/180);
		
			// azimut 
			var az = Math.atan2(n,d)*180/Math.PI;
		
			// condizione prevista da atan2 per mettere l'angolo negativo nel giusto quadrante
			if (az < 0) {az = az + 360}
			
			
			
			
			// ELEMENTI ORBITALI DELLA DATA 
			// LONGITUDINE MEDIA DEL PIANETA
			var mean_long = mercury_orb_element()[0];
			// INCLINAZIONE DELL'ORBITA 
			var inc_orb = mercury_orb_element()[3]; 
			// LONGITUDINE DEL NODO SCENDENTE 
			var long_node = mercury_orb_element()[4]; 
			// LONGITUDINE DEL PERIELIO
			var long_peri = mercury_orb_element()[5]; 
			// ANOMALIA MEDIA
			var mean_anomaly = mercury_orb_element()[6]; 
			// ARGOMENTO DEL PERIELIO
			var arg_peri = mercury_orb_element()[7]; 
			
			// ELEMENTI ORBITALI J2000
			// LONGITUDINE MEDIA DEL PIANETA
			var mean_long_2000 = mercury_orb_element()[8];
			// INCLINAZIONE DELL'ORBITA 
			var inc_orb_2000 = mercury_orb_element()[9]; 
			// LONGITUDINE DEL NODO SCENDENTE 
			var long_node_2000 = mercury_orb_element()[10]; 
			// LONGITUDINE DEL PERIELIO
			var long_peri_2000 = mercury_orb_element()[11]; 
			// ANOMALIA MEDIA
			var mean_anomaly_2000 = mercury_orb_element()[12]; 
			// ARGOMENTO DEL PERIELIO
			var arg_peri_2000 = mercury_orb_element()[13]; 
			
			
			
			
			
			
			

				
				// Toglie gli zeri al giorno creati con la ripetizione dei calcoli 
				obj.giorno.value = giorno; 
				
				// Toglie gli zeri al mese creati con la ripetizione dei calcoli 
				obj.mese.value = mese;
				
// ---------------------------- INIZIO DEL PROGRAMMA CHE CALCOLA PERIELIO ED AFELIO DEL PIANETA -------------------


     var numero_day = Math.floor(275 * mese / 9) - 2 * Math.floor((mese + 9)/12) + giorno - 30;  
	 var anno_dec = numero_day / 365 + anno;
	 
	 var k = 4.15201 * (anno_dec - 2000.12);
	 
	 if(k < 0){k = Math.ceil(k)}
	 else {k = Math.floor(k)} 	
	
	 perielio_jd = 2451590.257 + 87.96934963 * k - 0.0000000000 * Math.pow(k,2); 
	
	 k = k + 0.5; 
	 afelio_jd = 2451590.257 + 87.96934963 * k - 0.0000000000 * Math.pow(k,2); 
	 
// ---------------------------- FINE DEL PROGRAMMA CHE CALCOLA PERIELIO ED AFELIO DEL PIANETA -------------------


// ---------------------------- INIZIO DEL PROGRAMMA CHE CALCOLA LA CONGIUNZIONE INFERIORE DEL PIANETA -------------------

   var k_con_inf = Math.round((365.2425 * anno_dec + 1721060 - 2451612.023) / 115.8774771); 
   
   var jde_con_inf = 2451612.023 + k_con_inf * 115.8774771;
   
   var m_con_inf = 63.5867 + k_con_inf * 114.2088742;    
   
   // CONVERSIONE DI m_con_inf IN GRADI NEL RANGE 0-360 PER VALORI NEGATIVI 
   	if(m_con_inf < 0)
	{   
		// CALCOLO DEL NUMERO DI VOLTE IN CUI SI DEVE AGGIUNGERE 360°
		// TRONCA IL NUMERO NEGATIVO VERSO IL BASSO ES: -6.2 DIVENTA -6 OPPURE -6.9 DIVENTA -6
   		var m_con_inf_n = Math.ceil(m_con_inf / 360);
		// RENDE IN VALORE ASSOLUTO IL NUMERO 
   		m_con_inf_n = Math.abs(m_con_inf_n);
		// CICLO CHE AUMENTA DI 360° N VOLTE IL VALORE   
   		for (i=0; i< m_con_inf_n; i++){m_con_inf = m_con_inf + 360}	
		if(m_con_inf < 0){m_con_inf = m_con_inf + 360}
	}
   
   // CONVERSIONE DI m_con_inf IN GRADI NEL RANGE 0-360 PER VALORI POSITIVI
   	if(m_con_inf > 0)
	{   
		// CALCOLO DEL NUMERO DI VOLTE IN CUI SI DEVE AGGIUNGERE 360°
		// TRONCA IL NUMERO NEGATIVO VERSO IL BASSO ES: -6.2 DIVENTA -6 OPPURE -6.9 DIVENTA -6
   		var m_con_inf_n = Math.floor(m_con_inf / 360);
		// RENDE IN VALORE ASSOLUTO IL NUMERO 
   		m_con_inf_n = Math.abs(m_con_inf_n); 
		// CICLO CHE DIMINUISCE DI 360° N VOLTE IL VALORE   
   		for (i=0; i< m_con_inf_n; i++){m_con_inf = m_con_inf - 360}	
	}
   
 	var t_con_inf = (jde_con_inf - 2451545) / 36525;  
		
	
	var corr_con_inf = 
	+ 0.0545 + 0.0002 * t_con_inf
	+ (- 6.2008 + 0.0074 * t_con_inf + 0.00003 * Math.pow(t_con_inf,2)) * Math.sin(m_con_inf * r)
	+ (- 3.2750 - 0.0197 * t_con_inf + 0.00001 * Math.pow(t_con_inf,2)) * Math.cos(m_con_inf * r)
	+ (+ 0.4737 - 0.0052 * t_con_inf - 0.00001 * Math.pow(t_con_inf,2)) * Math.sin(2 * m_con_inf * r)
	+ (+ 0.8111 + 0.0033 * t_con_inf - 0.00002 * Math.pow(t_con_inf,2)) * Math.cos(2 * m_con_inf * r)
	+ (+ 0.0037 + 0.0018 * t_con_inf)                                   * Math.sin(3 * m_con_inf * r)
	+ (- 0.1768 					 + 0.00001 * Math.pow(t_con_inf,2)) * Math.cos(3 * m_con_inf * r)
	+ (- 0.0211 - 0.0004 * t_con_inf)                                   * Math.sin(4 * m_con_inf * r)
	+ (+ 0.0326 - 0.0003 * t_con_inf)									* Math.cos(4 * m_con_inf * r)
	+ (+ 0.0083 + 0.0001 * t_con_inf)  									* Math.sin(5 * m_con_inf * r) 
	+ (- 0.0040 + 0.0001 * t_con_inf) 									* Math.cos(5 * m_con_inf * r);
	  
	jde_con_inf_corr = jde_con_inf + corr_con_inf; 
   


// ---------------------------- FINE DEL PROGRAMMA CHE CALCOLA LA CONGIUNZIONE INFERIORE DEL PIANETA -------------------


// ---------------------------- INIZIO DEL PROGRAMMA CHE CALCOLA LA CONGIUNZIONE SUPERIORE DEL PIANETA -------------------

   var k_con_sup = Math.round((365.2425 * anno_dec + 1721060 - 2451554.084) / 115.8774771); 
   
   var jde_con_sup = 2451554.084 + k_con_sup * 115.8774771;
   
   var m_con_sup = 6.4822 + k_con_sup * 114.2088742;    
   
   // CONVERSIONE DI m_con_sup IN GRADI NEL RANGE 0-360 PER VALORI NEGATIVI 
   	if(m_con_sup < 0)
	{   
		// CALCOLO DEL NUMERO DI VOLTE IN CUI SI DEVE AGGIUNGERE 360°
		// TRONCA IL NUMERO NEGATIVO VERSO IL BASSO ES: -6.2 DIVENTA -6 OPPURE -6.9 DIVENTA -6
   		var m_con_sup_n = Math.ceil(m_con_sup / 360);
		// RENDE IN VALORE ASSOLUTO IL NUMERO 
   		m_con_sup_n = Math.abs(m_con_sup_n);
		// CICLO CHE AUMENTA DI 360° N VOLTE IL VALORE   
   		for (i=0; i< m_con_sup_n; i++){m_con_sup = m_con_sup + 360}	
		if(m_con_sup < 0){m_con_sup = m_con_sup + 360}
	}
   
   // CONVERSIONE DI m_con_sup IN GRADI NEL RANGE 0-360 PER VALORI POSITIVI
   	if(m_con_sup > 0)
	{   
		// CALCOLO DEL NUMERO DI VOLTE IN CUI SI DEVE AGGIUNGERE 360°
		// TRONCA IL NUMERO NEGATIVO VERSO IL BASSO ES: -6.2 DIVENTA -6 OPPURE -6.9 DIVENTA -6
   		var m_con_sup_n = Math.floor(m_con_sup / 360);
		// RENDE IN VALORE ASSOLUTO IL NUMERO 
   		m_con_sup_n = Math.abs(m_con_sup_n); 
		// CICLO CHE DIMINUISCE DI 360° N VOLTE IL VALORE   
   		for (i=0; i< m_con_sup_n; i++){m_con_sup = m_con_sup - 360}	
	}
   
 	var t_con_sup = (jde_con_sup - 2451545) / 36525;  
		
	var corr_con_sup = 
	- 0.0548 - 0.0002 * t_con_sup
	+ (+ 7.3894 - 0.0100 * t_con_sup - 0.00003 * Math.pow(t_con_sup,2)) * Math.sin(m_con_sup * r)
	+ (+ 3.2200 + 0.0197 * t_con_sup - 0.00001 * Math.pow(t_con_sup,2)) * Math.cos(m_con_sup * r)
	+ (+ 0.8383 - 0.0064 * t_con_sup - 0.00001 * Math.pow(t_con_sup,2)) * Math.sin(2 * m_con_sup * r)
	+ (+ 0.9666 + 0.0039 * t_con_sup - 0.00003 * Math.pow(t_con_sup,2)) * Math.cos(2 * m_con_sup * r)
	+ (+ 0.0770 - 0.0026 * t_con_sup)                                   * Math.sin(3 * m_con_sup * r)
	+ (+ 0.2758 + 0.0002 * t_con_sup - 0.00002 * Math.pow(t_con_sup,2)) * Math.cos(3 * m_con_sup * r)
	+ (- 0.0128 - 0.0008 * t_con_sup)                                   * Math.sin(4 * m_con_sup * r)
	+ (+ 0.0734 - 0.0004 * t_con_sup - 0.00001 * Math.pow(t_con_sup,2))	* Math.cos(4 * m_con_sup * r)
	+ (- 0.0122 - 0.0002 * t_con_sup)  									* Math.sin(5 * m_con_sup * r) 
	+ (+ 0.0173 - 0.0002 * t_con_sup) 									* Math.cos(5 * m_con_sup * r);
	  
	jde_con_sup_corr = jde_con_sup + corr_con_sup; 
// ---------------------------- FINE DEL PROGRAMMA CHE CALCOLA LA CONGIUNZIONE SUPERIORE DEL PIANETA -------------------

// ---------------------------- INIZIO DEL PROGRAMMA CHE CALCOLA L'ELONGAZIONE EST DEL PIANETA -------------------
	var corr_elo_est = 
	- 21.6101 + 0.0002 * t_con_inf
	+ (- 1.9803 - 0.0060 * t_con_inf + 0.00001 * Math.pow(t_con_inf,2)) * Math.sin(m_con_inf * r)
	+ (+ 1.4151 - 0.0072 * t_con_inf - 0.00001 * Math.pow(t_con_inf,2)) * Math.cos(m_con_inf * r)
	+ (+ 0.5528 - 0.0005 * t_con_inf - 0.00001 * Math.pow(t_con_inf,2)) * Math.sin(2 * m_con_inf * r)
	+ (+ 0.2905 + 0.0034 * t_con_inf + 0.00001 * Math.pow(t_con_inf,2))	* Math.cos(2 * m_con_inf * r)
	+ (- 0.1121 - 0.0001 * t_con_inf + 0.00001* Math.pow(t_con_inf,2))	* Math.sin(3 * m_con_inf * r)
	+ (- 0.0098 - 0.0015 * t_con_inf) 									* Math.cos(3 * m_con_inf * r)
	+ (+ 0.0192)					                                    * Math.sin(4 * m_con_inf * r)
	+ (+ 0.0111 + 0.0004 * t_con_inf)									* Math.cos(4 * m_con_inf * r)
	+ (- 0.0061)					  									* Math.sin(5 * m_con_inf * r) 
	+ (- 0.0032 - 0.0001 * t_con_inf)					 				* Math.cos(5 * m_con_inf * r);
	  
	jde_elo_est = jde_con_inf + corr_elo_est; 

	var elo_est =
	+ 22.4697 
	+ (- 4.2666 + 0.0054 * t_con_inf + 0.00002 * Math.pow(t_con_inf,2)) * Math.sin(m_con_inf * r)
	+ (- 1.8537 - 0.0137 * t_con_inf) 									* Math.cos(m_con_inf * r)
	+ (+ 0.3598 + 0.0008 * t_con_inf - 0.00001 * Math.pow(t_con_inf,2))	* Math.sin(2 * m_con_inf * r)
	+ (- 0.0680 + 0.0026 * t_con_inf)									* Math.cos(2 * m_con_inf * r)
	+ (- 0.0524 - 0.0003 * t_con_inf)					                * Math.sin(3 * m_con_inf * r)
	+ (+ 0.0052 - 0.0006 * t_con_inf) 									* Math.cos(3 * m_con_inf * r)
	+ (+ 0.0107 + 0.0001 * t_con_inf) 					                * Math.sin(4 * m_con_inf * r)
	+ (- 0.0013 + 0.0001 * t_con_inf)									* Math.cos(4 * m_con_inf * r)
	+ (- 0.0021)					  									* Math.sin(5 * m_con_inf * r) 
	+ (+ 0.0003)					 									* Math.cos(5 * m_con_inf * r);

// ---------------------------- FINE DEL PROGRAMMA CHE CALCOLA L'ELONGAZIONE EST DEL PIANETA -------------------


// ---------------------------- INIZIO DEL PROGRAMMA CHE CALCOLA L'ELONGAZIONE WEST DEL PIANETA -------------------
	var corr_elo_west = 
	+ 21.6249 - 0.0002 * t_con_inf
	+ (+ 0.1306 + 0.0065 * t_con_inf) 									* Math.sin(m_con_inf * r)
	+ (- 2.7661 - 0.0011 * t_con_inf + 0.00001 * Math.pow(t_con_inf,2)) * Math.cos(m_con_inf * r)
	+ (+ 0.2438 - 0.0024 * t_con_inf - 0.00001 * Math.pow(t_con_inf,2)) * Math.sin(2 * m_con_inf * r)
	+ (+ 0.5767 + 0.0023 * t_con_inf )									* Math.cos(2 * m_con_inf * r)
	+ (+ 0.1041)					                                    * Math.sin(3 * m_con_inf * r)
	+ (- 0.0184 + 0.0007 * t_con_inf) 									* Math.cos(3 * m_con_inf * r)
	+ (- 0.0051 - 0.0001 * t_con_inf)                                   * Math.sin(4 * m_con_inf * r)
	+ (+ 0.0048 + 0.0001 * t_con_inf)									* Math.cos(4 * m_con_inf * r)
	+ (+ 0.0026)					  									* Math.sin(5 * m_con_inf * r) 
	+ (+ 0.0037)					 									* Math.cos(5 * m_con_inf * r);
	  
	jde_elo_west = jde_con_inf + corr_elo_west; 

	var elo_west =
	+ 22.4143 - 0.0001 * t_con_inf
	+ (+ 4.3651 - 0.0048 * t_con_inf - 0.00002 * Math.pow(t_con_inf,2)) * Math.sin(m_con_inf * r)
	+ (+ 2.3787 + 0.0121 * t_con_inf - 0.00001 * Math.pow(t_con_inf,2)) * Math.cos(m_con_inf * r)
	+ (+ 0.2674 + 0.0022 * t_con_inf) 									* Math.sin(2 * m_con_inf * r)
	+ (- 0.3873 + 0.0008 * t_con_inf + 0.00001 * Math.pow(t_con_inf,2))	* Math.cos(2 * m_con_inf * r)
	+ (- 0.0369 - 0.0001 * t_con_inf)					                * Math.sin(3 * m_con_inf * r)
	+ (+ 0.0017 - 0.0001 * t_con_inf) 									* Math.cos(3 * m_con_inf * r)
	+ (+ 0.0059)					                                    * Math.sin(4 * m_con_inf * r)
	+ (+ 0.0061 + 0.0001 * t_con_inf)									* Math.cos(4 * m_con_inf * r)
	+ (+ 0.0007)					  									* Math.sin(5 * m_con_inf * r) 
	+ (- 0.0011)					 									* Math.cos(5 * m_con_inf * r);

// ---------------------------- FINE DEL PROGRAMMA CHE CALCOLA L'ELONGAZIONE WEST DEL PIANETA -------------------

// ---------------------------- INIZIO DEL PROGRAMMA CHE CALCOLA IL DIAMETRO DEL PIANETA -------------------
	var diam_mercury = 3.34 / delta0 * 2; 
// ---------------------------- FINE DEL PROGRAMMA CHE CALCOLA IL DIAMETRO DEL PIANETA -------------------

// ---------------------------- INIZIO DEL PROGRAMMA CHE CALCOLA LA FASE DEL PIANETA  -------------------
	var cos_i = (Math.pow(R,2) + Math.pow(delta0,2) - Math.pow(R_E_TL,2)) / (2 * R * delta0);
	var phase_angle = Math.acos(cos_i)*r1;
	// si possono usare indifferentemente entrambe queste formule, qui si opta per la seconda  
	// var fraz_disc = (1 + cos_i) / 2;
	var fraz_disc = (Math.pow((R + delta0),2) - Math.pow(R_E_TL,2)) / (4 * R * delta0) * 100; 	
// ---------------------------- FINE DEL PROGRAMMA CHE CALCOLA LA FASE DEL PIANETA -------------------

// ---------------------------- INIZIO DEL PROGRAMMA CHE CALCOLA L'ELONGAZIONE DEL PIANETA  -------------------
// 						sin elongazione = dist mercurio sole / dist terra sole * sin angolo fase 
	var elong_mercury = R / R_E_TL * Math.sin(phase_angle *r); 
	var elong_mercury = Math.asin(elong_mercury)*r1;
// ---------------------------- FINE DEL PROGRAMMA CHE CALCOLA L'ELONGAZIONE DEL PIANETA  -------------------
	
// ---------------------------- INIZIO DEL PROGRAMMA CHE CALCOLA LA MAGNITUDINE DEL PIANETA   -------------------
		 	var magni_mercury = -4.00 + 5 * Math.log10(R*delta0) + 0.01322 * phase_angle + 0.0000004247 * Math.pow(phase_angle,3);

		// questa è una vecchia formula non più in uso utilizzata fino al 1984
		// var magni_venus = -4.40 + 5 * Math.log10(R*delta0) + 0.0009 * phase_angle + 0.000239 * Math.pow(phase_angle,2) - 0.00000065 * Math.pow(phase_angle,3);
		
// ---------------------------- FINE DEL PROGRAMMA CHE CALCOLA LA MAGNITUDINE DEL PIANETA  -------------------
	
// ---------------------------- INIZIO DEL PROGRAMMA CHE CALCOLA LA SEPARAZIONE ANGOLARE DEL PIANETA DAL SOLE   -------------------
				var ar_sole = sole_tab(obj)[2]
				var dec_sole = sole_tab(obj)[3] 
				var ar_mercury = ar
				var dec_mercury = dec
				
				var sep_sole = Math.sin(dec_sole * r) * Math.sin(dec_mercury * r) + Math.cos(dec_sole * r) * Math.cos(dec_mercury * r) * Math.cos((ar_sole - ar_mercury) * r) 
				var sep_sole = Math.acos(sep_sole) * r1 
// ---------------------------- FINE DEL PROGRAMMA CHE CALCOLA LA SEPARAZIONE ANGOLARE DEL PIANETA DAL SOLE   -------------------
	
	
				
				//  scrittura dei dati in tabella 
				// coordinate apparenti				
				obj.CO_ECL_MERCURY.value =  mercury_c2(long_ecl_2) + '\n' + mercury_c1(lat_ecl_2); 

				// coordinate reali				
				obj.CO_ECL_MERCURY_REAL.value = mercury_real_c2(long_ecl_real_0) + '\n' + mercury_real_c1(lat_ecl_real_0); 

				// coordinate equatoriali 
				obj.CO_EQ_MERCURY.value =   mercury_c_ar(ar_h) + '\n' + mercury_c_dec(dec); 
				
				// coordinate equatoriali per la tabella sole e pianeti 					
				var ar_tab_mercury = mercury_c_ar(ar_h);
				var dec_tab_mercury = mercury_c_dec(dec); 

				// coordinate altazimutali 						
				obj.CO_HAZ_MERCURY.value =   mercury_c6(h) + '\n' + mercury_c7(az); 
				
				// coordinate altazimutali per la tabella sole e pianeti 					
				var h_tab_mercury = mercury_c6(h);
				var az_tab_mercury = mercury_c7(az); 
				
				
				// COLORA IL TEXTAREA SE ALTEZZA POSITIVA OPPURE NEGATIVA 
    			if (h > 0 && az < 180)
				{obj.CO_HAZ_MERCURY.style.backgroundColor='#090';obj.CO_HAZ_MERCURY.style.color='#FFF';}
    			if (h > 0 && az > 180)
				{obj.CO_HAZ_MERCURY.style.backgroundColor='#360';obj.CO_HAZ_MERCURY.style.color='#FFF';}
    			if (h < 0)
				{obj.CO_HAZ_MERCURY.style.backgroundColor='red';obj.CO_HAZ_MERCURY.style.color='#FFF';}
				
				

				// coordinate altazimutali 						
				obj.CO_RE_MERCURY.value =   x1.toFixed(8) + '\n' + y1.toFixed(8) + '\n' + z1.toFixed(8) ; 

				// distanza	geocentrica			
				obj.DIST_MERCURY.value =  delta0.toFixed(8) + '\n' + delta0_GM.toFixed(8); 
	
				// tempo luce 
				obj.TL_MERCURY.value =  (t0 *24 * 60 * 60).toFixed(2) + " sec" + '\n' + (t0 *24 * 60).toFixed(2) + " min" ;	
				
			// diametro
				obj.DIAM_MERCURY.value =  diam_mercury.toFixed(2) + " arcsec" ;	
				
			// angolo di fase e frazione illuminata disco 
				obj.PHASE_MERCURY.value =  phase_angle.toFixed(2) + " °" + '\n' + fraz_disc.toFixed(2) + " %" ;	
	
			// magnitudine 
				obj.MAGNI_MERCURY.value =  magni_mercury.toFixed(2) ;	
				
			// elongazione 
				obj.ELONG_MERCURY.value =  elong_mercury.toFixed(2) + " °" ;	


			// separazione angolare 
				obj.SEP_SOLE_MERCURY.value = sep_sole.toFixed(2) + " °"; 







	
		
				// distanza	eliocentrica 		
				obj.DIST_SUN_MERCURY.value =  R_TL.toFixed(8) + '\n' + R_TL_GM.toFixed(8); 
				
				// distanza eliocentrica per la tabella sole e pianeti 
				var dist_elio_tab_mercury = R_TL_GM.toFixed(8); 
				// distanza geocentrica per la tabella sole e pianeti 
				var dist_geo_tab_mercury = delta0_GM.toFixed(8); 
				
				
				
				
				
				
				// ELEMENTI ORBIALI	 LEGENDA			
				obj.MERCURY_ORB_LEGEND.value =  " L= Long. media" + '\n' + " a= Semiasse magg." + '\n' + " e= Eccentricità" + '\n' + " i= Incl. orbita" + '\n' + " Ω= Long. nodo asc." + '\n' + " π= Long. perielio" + '\n' + " M= Anomalia media" + '\n' + " ω= Arg. perielio"   ; 
				
				
				
				// ELEMENTI ORBIALI				
				obj.MERCURY_ORB_ELEMENT.value =  " L = " + mercury_c(mean_long) + '\n' + " a = " + mercury_orb_element()[1] + '\n' + " e = " + mercury_orb_element()[2].toFixed(10) +  '\n' + " i = " + mercury_c(inc_orb) + '\n' + " Ω = " + mercury_c(long_node) + '\n' + " π = " + mercury_c(long_peri) + '\n' + " M = " + mercury_c(mean_anomaly) + '\n' + " ω = " + mercury_c(arg_peri)   ; 


				// ELEMENTI ORBIALI				
				obj.MERCURY_ORB_ELEMENT_2000.value =  " L = " + mercury_c(mean_long_2000) + '\n' + " a = " + mercury_orb_element()[1] + '\n' + " e = " + mercury_orb_element()[2].toFixed(10) +  '\n' + " i = " + mercury_c(inc_orb_2000) + '\n' + " Ω = " + mercury_c(long_node_2000) + '\n' + " π = " + mercury_c(long_peri_2000) + '\n' + " M = " + mercury_c(mean_anomaly_2000) + '\n' + " ω = " + mercury_c(arg_peri_2000)   ; 





			// PERIELIO 
			var acdc = gregorian_perielio()[2]; 
			var acdcabs = Math.abs(acdc);
			if (acdc < 0){annosgn = "AC";} else {annosgn = "DC";}
			obj.PERI_MERCURY_D.value =  gregorian_perielio()[0] + " / " + gregorian_perielio()[1] + " / " +  acdcabs + " " + annosgn;
			obj.PERI_MERCURY_H.value =  gregorian_perielio()[3] + " : " + gregorian_perielio()[4] + " : " +  gregorian_perielio()[5] + " TDT"; 

			// AFELIO	
			var acdc = gregorian_afelio()[2]; 
			var acdcabs = Math.abs(acdc);
			if (acdc < 0){annosgn = "AC";} else {annosgn = "DC";}
			obj.AFE_MERCURY_D.value =  gregorian_afelio()[0] + " / " + gregorian_afelio()[1] + " / " +  acdcabs + " " + annosgn; 
			obj.AFE_MERCURY_H.value =  gregorian_afelio()[3] + " : " + gregorian_afelio()[4] + " : " +  gregorian_afelio()[5] + " TDT"; 
			
			
			// CONGIUNZIONE INFERIORE
			var acdc = gregorian_congiunzione_inferiore()[2]; 
			var acdcabs = Math.abs(acdc);
			if (acdc < 0){annosgn = "AC";} else {annosgn = "DC";}
			obj.MERCURY_INF_D.value =  gregorian_congiunzione_inferiore()[0] + " / " + gregorian_congiunzione_inferiore()[1] + " / " +  acdcabs + " " + annosgn; 
			obj.MERCURY_INF_H.value =  gregorian_congiunzione_inferiore()[3] + " : " + gregorian_congiunzione_inferiore()[4] + " : " +  gregorian_congiunzione_inferiore()[5] + " TDT"; 
			
			// CONGIUNZIONE SUPERIORE
			var acdc = gregorian_congiunzione_superiore()[2]; 
			var acdcabs = Math.abs(acdc);
			if (acdc < 0){annosgn = "AC";} else {annosgn = "DC";}
			obj.MERCURY_SUP_D.value =  gregorian_congiunzione_superiore()[0] + " / " + gregorian_congiunzione_superiore()[1] + " / " +  acdcabs + " " + annosgn; 
			obj.MERCURY_SUP_H.value =  gregorian_congiunzione_superiore()[3] + " : " + gregorian_congiunzione_superiore()[4] + " : " +  gregorian_congiunzione_superiore()[5] + " TDT"; 
		
			// ELONGAZIONE EST 
			var acdc = gregorian_elo_est()[2]; 
			var acdcabs = Math.abs(acdc);
			if (acdc < 0){annosgn = "AC";} else {annosgn = "DC";}
			obj.MERCURY_ELO_E_D.value =  gregorian_elo_est()[0] + " / " + gregorian_elo_est()[1] + " / " +  acdcabs + " " + annosgn; 
			obj.MERCURY_ELO_E_H.value =  gregorian_elo_est()[3] + " : " + gregorian_elo_est()[4] + " : " +  gregorian_elo_est()[5] + " TDT"; 
			obj.MERCURY_ELO_E_ANGLE.value =  mercury_elo_est(elo_est); 
		
			// ELONGAZIONE OVEST 
			var acdc = gregorian_elo_west()[2]; 
			var acdcabs = Math.abs(acdc);
			if (acdc < 0){annosgn = "AC";} else {annosgn = "DC";}
			obj.MERCURY_ELO_W_D.value =  gregorian_elo_west()[0] + " / " + gregorian_elo_west()[1] + " / " +  acdcabs + " " + annosgn; 
			obj.MERCURY_ELO_W_H.value =  gregorian_elo_west()[3] + " : " + gregorian_elo_west()[4] + " : " +  gregorian_elo_west()[5] + " TDT"; 
			obj.MERCURY_ELO_W_ANGLE.value =  mercury_elo_west(elo_west); 
		
		
		
			




			// MANDA I DATI AL PROGRAMMA VISIBILITA' SOLE, LUNA E PIANETI 	
			// MANDA I DATI AL GRAFICO ORTOGONALE E ZENITALE
			return [L,B,R,h,az,ar_tab_mercury,dec_tab_mercury,h_tab_mercury,az_tab_mercury,dist_elio_tab_mercury,dist_geo_tab_mercury];
			
			
				
		
			}
		else 
			{
				alert("ERRORE\n\nHAI TENTATO DI MODIFICARE LA PAGINA WEB\n\nSPIACENTE IL PROGRAMMA NON FUNZIONERA' PIU'"); 
			}
		
	}
